this.name        = "Automatic ECM System";
this.author      = "Switeck";
this.licence        = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.copyright      = "(C) 2014 Switeck";
this.description = "Automatic ECM  System - Simple Auto-firing system for ECM.";
this.version     = "0.4.0 - for Oolite 1.79 and later";

"use strict";

this.activated = function()
{
	if(player.ship.equipmentStatus("EQ_AUTOECM") === "EQUIPMENT_OK") {
		if(missionVariables.autoECM) {
			missionVariables.autoECM = 0;
			player.commsMessage("Automatic ECM System Disabled.",6);
		} else {
			missionVariables.autoECM = 1;
			player.commsMessage("Automatic ECM System ONLINE!",6);
		}
	} else player.commsMessage("AutoECM Equipment damaged!",6);
}

this.shipLaunchedFromStation = this.shipExitedWitchspace = function() {
	if(player.ship.equipmentStatus("EQ_AUTOECM") === "EQUIPMENT_DAMAGED" || (player.ship.equipmentStatus("EQ_AUTOECM") === "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_ECM") === "EQUIPMENT_DAMAGED") ) player.consoleMessage("Auto ECM and/or ECM System DAMAGED!",5)
	else if(missionVariables.autoECM) player.consoleMessage("Auto ECM System ready and enabled.",5);
}

this.shipAttackedWithMissile = function(missile, whom) {
	if(player.ship.equipmentStatus("EQ_AUTOECM") === "EQUIPMENT_OK" && missionVariables.autoECM) {
		if(player.ship.equipmentStatus("EQ_ECM") === "EQUIPMENT_OK") {
			if(player.ship.energy > 32) {
				player.ship.fireECM();
				player.consoleMessage("Missile detected, using ECM!",6); // Use ECM.
			} else player.consoleMessage("LOW Energy - ECM NOT triggered! Missile inbound!",6); // Energy too low to use ECM?
		} else { // ECM N/A!
//			player.ship.target = missile; // Target the enemy missile. <- Removed since this should be a EQ_SCANNER_SHOW_MISSILE_TARGET feature.
			player.consoleMessage("ECM N/A - DANGER: Incoming missile!",6);	// Panic!!
		}
	}
	if(player.ship.equipmentStatus("EQ_SCANNER_SHOW_MISSILE_TARGET") === "EQUIPMENT_DAMAGED") player.consoleMessage("Missile Targeter offline, unknown missile inbound.",6);	// Missile Scanner/Targeter N/A?
}

this.mode = function ()
{
	if(player.ship.equipmentStatus("EQ_AUTOECM") === "EQUIPMENT_OK") {
		if(!missionVariables.autoECM) player.commsMessage("Automatic ECM System Disabled.",6)
		else player.commsMessage("Automatic ECM System ONLINE!",6);
	} else player.commsMessage("AutoECM Equipment damaged!",6);
}